/*
 * TrkPhSinCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkPhSinCut.h The TrkPhSinCut class definition file */

#ifndef TRKPHSINCUT_H_
#define TRKPHSINCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The single physical track cut.
 * Only events with a single physical track (selected according to the specified sorting method) survive this selection.
 */

class TrkPhSinCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param sortingMethod The sorting method to be used to select the track.
   */
  TrkPhSinCut(const char *cutName, const char *sortingMethod) :
    PamCut(cutName), _sortingMethod(sortingMethod) {
  }
  /*! @brief Destructor. */
  ~TrkPhSinCut() {
  }

  /*! @brief The single physical track check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if a single physical track has been found in the event
   * @return 0 if the event has not exactly one physical track or if the track is meaningless
   *         (nstep > 100 or chi2 < 0.)
   */
  int Check(PamLevel2 *event);

  int iTrackTof; ///< TOF_index for TRK-track for the last good event.

  /*! @brief The TrkTrack for the last good event.
   *
   * When this cut checks an event, it stores its TrkTrack (selected according to the specified sortingMethod). This can then be used by successive cuts.
   */
  TrkTrack *trkTrack;

  /*! @brief The PamTrack for the last good event.
   *
   * When this cut checks an event, it stores its PamTrack (selected according to the specified sortingMethod). This can then be used by successive cuts.
   */
  PamTrack *pamTrack;

private:

  const char *_sortingMethod;

};
#endif /* TRKPHSINCUT_H_ */
