/*
 * TrkMDRCut.h
 *
 *  Created on: 28-Jul-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkMDRCut.h The TrkMDRCut class definition file */

#ifndef TRKMDRCUT_H_
#define TRKMDRCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The cut on TRK MDR.
 *
 * This cut discards an event if the MDR (defined as 1./sqrt(coval[4][4]), in GV) is not greater than a minimum threshold value |MDRMin| (GV).
 *
 */
class TrkMDRCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param MDRMin The minimum threshold MDR in GV (should be positive; if negative, the absolute value is considered here).
   */
  TrkMDRCut(const char *cutName, float MDRMin) :
    PamCut(cutName), _MDRMin(MDRMin) {
    }

  /*! @brief Destructor. */
  ~TrkMDRCut() {
  }

  /*! @brief The MDR check.
   *
   * The event is discarded if its MDR is not greater than |MDRMin|
   *
   * @param event The event to analyze.
   * @return #CUTOK if the MDR condition is satisfied.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);


private:

  float _MDRMin;

};

#endif /* TRKMDRCUT_H_ */
