/*
 * TrkIdCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkIdCut.h The TrkIdCut class definition file */

#ifndef TRKIDCUT_H_
#define TRKIDCUT_H_
#include "../../PamCutBase/PamCutBase.h"

/*! @brief The TrkId cut.
 *
 * This cut checks if the event has an image track, and discards it if the
 * ambiguity is not solved.
 */

class TrkIdCut: public PamCut {

public:

  /*! @brief Constructor.  */
  TrkIdCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~TrkIdCut() {
  }

  /*! @brief The TrkId check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if
   * @return 0
   */

  int Check(PamLevel2 *event);

};

#endif /* TRKIDCUT_H_ */
