/*
 * TrkGeomCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: N. Mori, S. Ricciarini
 */

/*! @file TrkGeomCut.cpp The TrkGeomCut class implementation file */

#include "TrkGeomCut.h"

int TrkGeomCut::Check(PamLevel2 *event) {


    if(event->GetNTracks(_trkAlg)==0)return 0;

//  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();
    ExtTrack *trkTrack = event->GetTrack(0,_trkAlg)->GetExtTrack();
  
  Float_t xT, yT;

  for (int igf = 0; igf < TrkParams::nGF; igf++) { // loop on GF planes

    if (igf==5 || igf==10) { // M1 and M2 planes
      xT = _xMagnTol;
      yT = _yMagnTol;
    }
    else {
      xT = _xTol;
      yT = _yTol;
    }

    // check done for all 14 planes
    if (!(TrkParams::xGF_min[igf] + xT < trkTrack->xGF[igf] && trkTrack->xGF[igf] < TrkParams::xGF_max[igf] - xT))
      return 0;
    if (!(TrkParams::yGF_min[igf] + yT < trkTrack->yGF[igf] && trkTrack->yGF[igf] < TrkParams::yGF_max[igf] - yT))
      return 0;

  } // end loop on GF planes

  return CUTOK;
}
