/*
 * TrkGeomCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkGeomCut.h The TrkGeomCut class definition file */

#ifndef TRKGEOMCUT_H_
#define TRKGEOMCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker fiducial acceptance cut.
 * This cut checks if the track is inside the fiducial acceptance chosen for the tracker.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkGeomCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * The parameters are the width of the regions on each side of a view that define the
   * fiducial acceptance region. The detector size is therefore reduce by an amount of xTol
   * (yTol) on each side of the X (Y) view.
   *
   * @param cutName The cut's name.
   * @param xTol The fiducial border on X view in cm.
   * @param yTol The fiducial border on Y view in cm.
   */
  TrkGeomCut(const char *cutName, float xTol, float yTol) :
    PamCut(cutName), _xTol(xTol), _yTol(yTol) {
  }
  /*! @brief Destructor. */
  ~TrkGeomCut() {
  }

  /*! @brief The tracker fiducial acceptance check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the track is inside the fiducial acceptance.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _xTol;
  float _yTol;

};
#endif /* TRKGEOMCUT_H_ */
