/*
 * TrkGeomCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TrkGeomCut.cpp The TrkGeomCut class implementation file */

#include "TrkGeomCut.h"

int TrkGeomCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  for (int igf = 0; igf < TrkParams::nGF; igf++) { // loop on GF planes

    // check done for all 14 planes
    if (!(TrkParams::xGF_min[igf] + _xTol < trkTrack->xGF[igf] && trkTrack->xGF[igf] < TrkParams::xGF_max[igf] - _xTol))
      return 0;
    if (!(TrkParams::yGF_min[igf] + _yTol < trkTrack->yGF[igf] && trkTrack->yGF[igf] < TrkParams::yGF_max[igf] - _yTol))
      return 0;

  } // end loop on GF planes

  return CUTOK;
}
