/*
 * TrkDedxHeCut.h
 *
 *  Created on: 28/gen/2010
 *      Author: Nicola Mori
 */

#ifndef TRKDEDXHECUT_H_
#define TRKDEDXHECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The dE/dX cut to select He
 * This cut discards all the events whose rigidity modulus and dE/dX (both given by TRK) are outside a pre-defined band
 * (defined by E. Vannuccini and N. Mori). The function defining the upper and lower limits of the band is: dE/dx = a + b/R^2,
 * where a and b are parameters which take different values for the upper and lower limit.
 * CUT DEPENDENCIES: TrkPhSinCut for object TrkTrack
 */
class TrkDedxHeCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkDedxHeCut(const char *cutName) :
    PamCut(cutName) {
  }

  /*! @brief Destructor. */
  ~TrkDedxHeCut() {
  }

  /*! @brief The tracker dE/dx vs rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the event lies inside the helium band
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);
};
#endif /* TRKDEDXHECUT_H_ */
