/*
 * TrkDedxHCut.h
 *
 *  Created on: 15-mar-2010
 *      Author: S. Ricciarini
 */

/*! @file TrkDedxHCut.h The TrkDedxHCut class definition file */

#ifndef TRKDEDXHCUT_H_
#define TRKDEDXHCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The dE/dX cut to select H and anti-H.
 * This cut discards all the events whose rigidity modulus and dE/dX (both given by TRK) are outside a pre-defined band (lower band: by Nico De Simone; upper band: by Nicola Mori).
 * Here the rigidity is defined as pc/Ze (GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus: therefore the rigidity can be positive or negative.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */
class TrkDedxHCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkDedxHCut(const char *cutName, const char *trkAlg) :
    PamCut(cutName), _trkAlg(trkAlg) {

  }

  /*! @brief Destructor. */
  ~TrkDedxHCut() {

  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the (rigidity modulus , dE/dX) point is inside the pre-defined band.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

    const char *_trkAlg;

  // lower cut line
  static const int _nLow = 23;
  static const Double_t _xLow[];
  static const Double_t _yLow[];

};
#endif /* TRKDEDXHCUT_H_ */
