/*
 * TrkDOFCut.h
 *
 *  Created on: 04/set/2009
 *      Author: Nicola Mori
 */

/*! @file TrkDOFCut.h The TrkDOFCut class definition file */

#ifndef TRKDOFCUT_H_
#define TRKDOFCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker \#DOF cut.
 *
 * This cut rejects those events which have a number of degrees of freedom less than a threshold.
 * It is possible also to set an upper limit.
 * The number of degrees of freedom is defined as the number of clusters along the track minus
 * the number of parameters of the track, which is 5.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkDOFCut: public PamCut {

public:
  /*! @brief Constructor.
   *

   *
   * @param cutName The cut's name.
   * @param minDOF The minimum number of degrees of freedom. Range: [0, 7].
   * @param maxDOF The maximum number of degrees of freedom. Range: [minDOF, 7]
   */
  TrkDOFCut(const char *cutName, unsigned int minDOF, unsigned int maxDOF = 7) :
    PamCut(cutName), _minDOF((int) minDOF + 5), _maxDOF((int) maxDOF + 5) {
  }
  /*! @brief Destructor. */
  ~TrkDOFCut() {
  }

  /*! @brief The tracker \#DOF check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the track has a number of associated clusters greater than or equal to minDOF + 5
   *                and less than or equal to maxDOF + 5;
   *
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  int _minDOF;
  int _maxDOF;

};
#endif /* TRKDOFCUT_H_ */
