/*
 * TrkChi2XDeflTimeCut.h
 *
 *  Created on: 6-oct-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkChi2XDeflTimeCut.h The TrkChi2XDeflTimeCut class definition file */

#ifndef TRKCHI2XDEFLTIMECUT_H_
#define TRKCHI2XDEFLTIMECUT_H_

#include "../TrkChi2DeflTimeCut/TrkChi2DeflTimeCut.h"

/*! @brief The tracker chi2 for X view vs deflection cut.
 *
 * Events whose track has been fitted with a chi2 greater than Chi2(eta) are discarded.
 * Chi2(eta) is a function which gives the maximum value of chi2 associated to a certain
 * deflection eta; in current implementation it is parameterized as:
 *
 *   Chi2(eta) = p0 + p1 * eta^2 + p2 * eta ^4
 *
 * where p0, p1 and p2 are parameters. These are read from a file, and are supposed to be
 * computed month by month.
 *
 */

class TrkChi2XDeflTimeCut: public TrkChi2DeflTimeCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param calibFile Path for the calibration file. The format of the file's rows is:
   *                  YYMM efficiency p0 p1 p2
   */
  TrkChi2XDeflTimeCut(const char *cutName, const char *calibFile) :
    TrkChi2DeflTimeCut(cutName, calibFile) {
  }

  /*! @brief Destructor. */
  ~TrkChi2XDeflTimeCut() {
  }

private:
  double _GetChi2(PamLevel2 *event);

};
#endif /* TRKCHI2XDEFLTIMECUT_H_ */
