/*
 * TrkChi2QualCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TrkChi2QualCut.cpp The TrkChi2QualCut class implementation file */

#include "TrkChi2QualCut.h"

int TrkChi2QualCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  float p0 = 1.111588e+00;
  float p1 = 1.707656e+00;
  float p2 = 1.489693e-01;
  float def_0 = 0.07;
  float chi2m025_0 = p0 + fabs(def_0) * p1 + def_0 * def_0 * p2;

  float chi2m025 = p0 + fabs(trkTrack->GetDeflection()) * p1 + pow(trkTrack->GetDeflection(), 2) * p2;

  float chi2m = pow(chi2m025 - chi2m025_0 + pow(6.4, 0.25), 4.); // cut at ~90% of chi^2 distribution

  if (!(trkTrack->chi2 < chi2m))
    return 0;
  return CUTOK;

}
