/*
 * TrkChi2QualCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkChi2QualCut.h The TrkChi2QualCut class definition file */

#ifndef TRKCHI2QUALCUT_H_
#define TRKCHI2QUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker chi2 quality cut.
 *
 * This cut performs a specific check on chi2 of the track (see code for details)
 */

class TrkChi2QualCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkChi2QualCut(char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~TrkChi2QualCut() {
  }

  /*! @brief The tracker chi2 quality check.
   *
   *
   * @param event The event to analyze.
   * @return #CUTOK if chi2 is satisfying.
   * @return 0 if not
   */
  int Check(PamLevel2 *event);

};
#endif /* TRKCHI2QUALCUT_H_ */
