/*
 * TrkChi2DeflTimeCut.cpp
 *
 *  Created on: 6-oct-2009
 *      Author: S. Ricciarini
 */

#include "TrkChi2DeflTimeCut.h"

double TrkChi2DeflTimeCut::_GetChi2(PamLevel2 *event) {
//  return event->GetTrack(0)->GetTrkTrack()->chi2;
    return (event->GetNTracks(_trkAlg)<=0 ? -1. : event->GetTrack(0,_trkAlg)->GetExtTrack()->chi2);
}

int TrkChi2DeflTimeCut::Check(PamLevel2 *event) {

  double chi2 = _GetChi2(event);
  if (chi2 < 0.)
    return 0;
//   Double_t etaMod = fabs(event->GetTrack(0)->GetTrkTrack()->GetDeflection());
//   Int_t nHitX = event->GetTrack(0)->GetTrkTrack()->GetNX();
  Double_t etaMod = fabs(event->GetTrack(0,_trkAlg)->GetExtTrack()->GetDeflection());
  Int_t nHitX = event->GetTrack(0,_trkAlg)->GetExtTrack()->GetNX();
  
//  cout << " nHitX " << nHitX << endl;
  
  if (nHitX == 3) {
    for (UInt_t i = 0; i < _iDayFirst_nHitX3.size(); i++) {
      _iDayFirst.push_back(_iDayFirst_nHitX3[i]);
      _iDayLast.push_back(_iDayLast_nHitX3[i]);
      for (int iPar=0; iPar<_nPar; iPar++) {
        _p[iPar].push_back(_p_nHitX3[iPar][i]);
      }
    }	
  }
  else if (nHitX >= 4) {
    for (UInt_t i = 0; i < _iDayFirst_nHitX4.size(); i++) {
      _iDayFirst.push_back(_iDayFirst_nHitX4[i]);
      _iDayLast.push_back(_iDayLast_nHitX4[i]);
      for (int iPar=0; iPar<_nPar; iPar++) {
        _p[iPar].push_back(_p_nHitX4[iPar][i]);
      }
    }	
  }
  else {
    return 0;
  }

  _time.Set(event->GetOrbitalInfo()->absTime, kFALSE, 0, kFALSE);
  // TTimestamp::GetDate() returns date in format YYYYMMDD so to compare it
  // with 6-digits dates (YYMMDD) we must subtract 20000000

  Int_t iDaySel = (_time.GetDate(kFALSE) - 20000000); // note: GetDate returns an unsigned integer
//  cout << "day " << iDaySel << endl;

  bool found = false;
  for (UInt_t i = 0; i < _iDayFirst.size(); i++) {
    if (_iDayFirst[i] <= iDaySel && iDaySel <= _iDayLast[i]) {
      for (int iPar=0; iPar<_nPar; iPar++) {
        _pSel[iPar] = _p[iPar][i];
      }
      
//      cout << "FOUND: day " << iDaySel << endl;
//      cout << _iDayFirst[i] << " " << _iDayLast[i] << endl;
//      cout << _pSel[0] << " " << _pSel[1] << " " << _pSel[2] << " " << _pSel[3] << endl;

      found = true;
      break;
    }
  }

  if (!found) {
    cout << "not found" << endl;
    cout << endl;
    return 0;
  }

//  for (int iPar=0; iPar<_nPar; iPar++) {
//    cout << " p" << iPar << ": " << _pSel[iPar] << endl;
//  }
//  cout << endl;

  double chi2max;
  
  if (_nPar==4) {
  
    chi2max=_pSel[0] + _pSel[1] * pow(etaMod, _pSel[2]) * (1. + pow(_pSel[3] * etaMod, 2));

//    cout << "chi2max " << chi2max << endl;

  }
  else if (_nPar==5) {
    chi2max=_pSel[0] + _pSel[1] * pow(etaMod, _pSel[2]) * (1. + pow(_pSel[3] * etaMod, _pSel[4]));
  }
  else {
    chi2max=-1;
  }

//  cout << "chi2 " << chi2 << endl;
  
  if (chi2 > chi2max) {
  
//    cout << "KO" << endl;
    
    return 0;

  }

//  cout << "OK" << endl;

  return CUTOK;

}
