/*
 * TrkChi2Defl50Cut.h
 *
 *  Created on: 7-apr-2009
 *      Author: Nicola Mori
 */

#ifndef TRKCHI2DEFL50CUT_H_
#define TRKCHI2DEFL50CUT_H_

/*! @file TrkChi2Defl50Cut.h The TrkChi2Defl50Cut class definition file */

#include "../TrkChi2DeflCut.h"

/*! @brief The tracker chi2 vs deflection cut at ~ 50% efficiency.
 *
 * This cut is a specialization of TrkChi2DeflCut, which gives about
 * 50% efficiency.
 */

class TrkChi2Defl50Cut: public TrkChi2DeflCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkChi2Defl50Cut(const char *cutName) :
    TrkChi2DeflCut(cutName, 1.48, 35.04, 25.44) {
  }
  /*! @brief Destructor. */
  ~TrkChi2Defl50Cut() {
  }

};
#endif /* TRKCHI2DEFL50CUT_H_ */
