/*
 * TrkChi2Defl95Cut.h
 *
 *  Created on: 7-apr-2009
 *      Author: Nicola Mori
 */

#ifndef TRKCHI2DEFL95CUT_H_
#define TRKCHI2DEFL95CUT_H_

/*! @file TrkChi2Defl95Cut.h The TrkChi2Defl95Cut class definition file */

#include "../TrkChi2DeflCut.h"

/*! @brief The tracker chi2 vs deflection cut at ~ 95% efficiency.
 *
 * This cut is a specialization of TrkChi2DeflCut, which gives about
 * 95% efficiency.
 */

class TrkChi2Defl95Cut: public TrkChi2DeflCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkChi2Defl95Cut(const char *cutName) :
    TrkChi2DeflCut(cutName, 12.42, 199.5, 153.1) {
  }
  /*! @brief Destructor. */
  ~TrkChi2Defl95Cut() {
  }

};
#endif /* TRKCHI2DEFL95CUT_H_ */
