/*
 * TrkChi2Defl90Cut.h
 *
 *  Created on: 7-apr-2009
 *      Author: Nicola Mori
 */

#ifndef TRKCHI2DEFL90CUT_H_
#define TRKCHI2DEFL90CUT_H_

/*! @file TrkChi2Defl90Cut.h The TrkChi2Defl90Cut class definition file */

#include "../TrkChi2DeflCut.h"

/*! @brief The tracker chi2 vs deflection cut at ~ 90% efficiency.
 *
 * This cut is a specialization of TrkChi2DeflCut, which gives about
 * 90% efficiency.
 */

class TrkChi2Defl90Cut: public TrkChi2DeflCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkChi2Defl90Cut(const char *cutName) :
    TrkChi2DeflCut(cutName, 5.99, 131., 99.09) {
  }
  /*! @brief Destructor. */
  ~TrkChi2Defl90Cut() {
  }

};
#endif /* TRKCHI2DEFL90CUT_H_ */
