/*
 * TrkCalQualCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: Nicola Mori
 */

/*! @file TrkCalQualCut.h The TrkCalQualCut class definition file */

#ifndef TRKCALQUALCUT_H_
#define TRKCALQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @enum TRKCAL_Values Tracker calibration flags */
enum TRKCAL_Values {
  TRKCAL_ONLINE, ///< Online calibration.
  TRKCAL_DEFAULT, ///< Default calibration.
  TRKCAL_BAD, ///< Bad calibration.
};

/*! @brief The tracker calibration quality cut.
 */
class TrkCalQualCut: public PamCut {

public:
  /*! @brief Constructor. */
  TrkCalQualCut(const char *cutName) :
    PamCut(cutName) {
  }
  /*! @brief Destructor. */
  ~TrkCalQualCut() {
  }

  /*! @brief The tracker calibration quality check.
   *
   * This method checks the calibration of the event and updates the calibration
   * information returned by #GetCalibration
   *
   * @param event The event to analyze.
   * @return #CUTOK if tracker calibration is online or default.
   * @return #TRKCAL_BAD otherwise.
   */
  int Check(PamLevel2 *event);

  /*! @brief Returns the calibration type of the last examined event
   *
   * @return #TRKCAL_BAD if the event has a bad calibration.
   * @return #TRKCAL_ONLINE if the event uses a validated online calibration.
   * @return #TRKCAL_DEFAULT if the event uses the default calibration.
   *
   */

  inline int GetCalibration();

private:
  int _calibration;
};
#endif /* TRKCALQUALCUT_H_ */
