/*
 * RigFillCut.cpp
 *
 *  Created on: 27-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file RigFillCut.cpp The TrkRigGeoCut class implementation file */

#include "RigFillCut.h"

int RigFillCut::Check(PamLevel2 *event) {

  float rigThreshold = _thresholdCoeff * event->GetOrbitalInfo()->GetCutoffSVL();

  if (rigThreshold > _binning[_binning.size() - 1] || rigThreshold < _binning[0]) {
    return THRESHRIGOUT;
  }

  float rig = event->GetTrack(0)->GetTrkTrack()->GetRigidity();

  if (rig > _binning[_binning.size() - 1] || rig < _binning[0]) {
    return RIGOUT;
  }

  return CUTOK;
}

void RigFillCut::OnGood(PamLevel2 *event) {

  float rigThreshold = _thresholdCoeff * event->GetOrbitalInfo()->GetCutoffSVL();
  float rig = event->GetTrack(0)->GetTrkTrack()->GetRigidity();

  //Bin identification: value must be less than (<) bin maximum
  
  int i = 1;
  while (rig >= _binning[i]) {
    i++;
  }
  i--;

//  cout << _binning[i] << " < " <<  rig  << " < " << _binning[i+1] << endl;

  int j = 1;
  while (rigThreshold >= _binning[j]) {
    j++;
  }
  j--;

//  cout << _binning[j] << " < " <<  rigCutoff  << " < " << _binning[j+1] << endl;
//  cout << endl;

  _histogram[i][j]++;
}
