/*
 * TrkCalQualCut.cpp
 *
 *  Created on: 10-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TrkCalQualCut.cpp The TrkCalQualCut class implementation file */

#include "TrkCalQualCut.h"

int TrkCalQualCut::Check(PamLevel2 *event) {

    if ((event->GetRunInfo()->TRK_CALIB_USED == 1 || event->GetRunInfo()->TRK_CALIB_USED == 2 ) &&
        (event->GetRunInfo()->VALIDATION == 1)){
      _calibration = TRKCAL_ONLINE;
      return CUTOK; // VALIDATED on-line calibration
    }
    else if (event->GetRunInfo()->TRK_CALIB_USED == 104){
      _calibration = TRKCAL_DEFAULT;
      return CUTOK; // default calibration
    }
    _calibration = TRKCAL_BAD;
    return TRKCAL_BAD;
}

inline int TrkCalQualCut::GetCalibration(){
  return _calibration;
}
