/*
 * TrkRigGeoCut.cpp
 *
 *  Created on: 25-mar-2009
 *      Author: Nicola Mori
 */

/*! @file TrkRigGeoCut.cpp The TrkRigGeoCut class implementation file */

#include "TrkRigGeoCut.h"

int TrkRigGeoCut::Check(PamLevel2 *event) {

    if(event->GetNTracks(_trkAlg)==0)return 0;    
    ExtTrack *track = event->GetTrack(0,_trkAlg)->GetExtTrack();

    if (track->GetRigidity() < _thresholdCoeff * event->GetOrbitalInfo()->GetCutoffSVL()) {
	return 0;
    }
    
    return CUTOK;
}
