/*
 * TrkCuts.h
 *
 *  Created on: 15-mag-2009
 *      Author: Nicola Mori
 */

/*! @file TrkCuts.h This header contains the inclusion of all Trk cuts. */

#ifndef TRKCUTS_H_
#define TRKCUTS_H_

#include "RigFillCut/RigFillCut.h"                               // Rigidity - cutoff rigidity histogram
#include "TrkCalQualCut/TrkCalQualCut.h"                         // Tracker calibration
#include "TrkChi2DeflCut/TrkChi2DeflCut.h"                       // Chi2 as a function of deflection
#include "TrkChi2DeflCut/TrkChi2DeflEffCut/TrkChi2Defl95Cut.h"   // Chi2 as a function of deflection at ~95% efficiency
#include "TrkChi2DeflCut/TrkChi2DeflEffCut/TrkChi2Defl90Cut.h"   // Chi2 as a function of deflection at ~90% efficiency
#include "TrkChi2DeflCut/TrkChi2DeflEffCut/TrkChi2Defl75Cut.h"   // Chi2 as a function of deflection at ~75% efficiency
#include "TrkChi2DeflCut/TrkChi2DeflEffCut/TrkChi2Defl50Cut.h"   // Chi2 as a function of deflection at ~50% efficiency
#include "TrkChi2QualCut/TrkChi2QualCut.h"                       // Chi2
#include "TrkDedxHCut/TrkDedxHCut.h"                             // Tracker dE/dX for H
#include "TrkGeomCut/TrkGeomCut.h"                               // Fiducial acceptance with tracker's track
#include "TrkHitQualCut/TrkHitQualCut.h"                         // Number of hits and lever arm
#include "TrkIdCut/TrkIdCut.h"                                   // Track identification
#include "TrkIonCut/TrkIonCut.h"                                 // Energy release
#include "TrkNucleiZCut/TrkNucleiZCut.h"                         // Particle 's charge cut based on TrkNuclei
#include "TrkPhSinCut/TrkPhSinCut.h"                             // Single physical track
#include "TrkRigCut/TrkRigCut.h"                                 // Rigidity minimum
#include "TrkRigGeoCut/TrkRigGeoCut.h"                           // Rigidity vs. Cutoff
#include "TrkRigRangeCut/TrkRigRangeCut.h"                       // Rigidity range
#include "TrkRunValCut/TrkRunValCut.h"                           // TRK run validation
#include "TrkSigmaDeflCut/TrkSigmaDeflCut.h"                     // Sigma-Deflection

#endif /* TRKCUTS_H_ */
