/*
 * TrkIonCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkIonCut.h The TrkIonCut class definition file */

#ifndef TRKIONCUT_H_
#define TRKIONCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker ionization cut.
 * Cut on dE/dx to select MIP.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkIonCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param maxRelease The maximum mean ionization (in MIP) in the tracker planes above which an event is discarded. Default: 3.
   * @param minRelease The minimum mean ionization (in MIP) in the tracker planes below which an event is discarded. Default: 0.
   */
  TrkIonCut(const char *cutName, float maxRelease = 3., float minRelease = 0.) :
    PamCut(cutName), _maxRelease(maxRelease), _minRelease(minRelease) {
  }
  /*! @brief Destructor. */
  ~TrkIonCut() {
  }

  /*! @brief The tracker ionization check.
   *
   * If the mean energy release in the tracker planes in MIP is greater
   * than the threshold (constructor's parameter) the event is discarded.
   * @param event The event to analyze.
   * @return #CUTOK if mean dE/dx is less than maxRelease and more than minRelease.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _maxRelease, _minRelease;

};
#endif /* TRKIONCUT_H_ */
