/*
 * TrkHitQualCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkHitQualCut.h The TrkHitQualCut class definition file */

#ifndef TRKHITQUALCUT_H_
#define TRKHITQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker hit quality cut.
 *
 * This cut performs a check on the number of hits on X and Y view
 * and on the lever arm.
 *
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkHitQualCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param xMinHit The minimum hits along the track for X view
   * @param yMinHit The minimum hits along the track for X view
   * @param xLeverArm The Minimum lever arm
   */
  TrkHitQualCut(const char *cutName, int xMinHit, int yMinHit, int xLeverArm) :
    PamCut(cutName), _xMinHit(xMinHit), _yMinHit(yMinHit), _xLeverArm(xLeverArm) {
  }
  /*! @brief Destructor. */
  ~TrkHitQualCut() {
  }

  /*! @brief The tracker hit quality check.
   *
   * The event is rejected if X hits or Y hist or X lever arm is less than the
   * parameter passed to the constructor.
   *
   * @see TrkHitQualCut
   * @param event The event to analyze.
   * @return #CUTOK if X hits, Y hits and X lever arm are greater or equal than the minimum values.
   * @return 0 if at least one of the above conditions is not matched.
   */
  /*TODO: implementare un tipo di ritorno diverso a seconda che fallisca il check sul numero di hit o quello
   * sul lever arm (opzionale)
   */
  int Check(PamLevel2 *event);

private:

  int _xMinHit, _yMinHit, _xLeverArm;

};
#endif /* TRKHITQUALCUT_H_ */
