/*
 * TrkChi2DeflCut.cpp
 *
 *  Created on: 7-apr-2009
 *      Author: Nicola Mori
 */

#include "TrkChi2DeflCut.h"

int TrkChi2DeflCut::Check(PamLevel2 *event) {

  float chi2 = event->GetTrack(0)->GetTrkTrack()->chi2;
  if (chi2 < 0.)
    return 0;
  float eta2 = event->GetTrack(0)->GetTrkTrack()->GetDeflection(); //Sign doesn't matter
  eta2 *= eta2;  // Now eta2 is deflection^2

#ifdef DEBUGPAMCUT

  h_trk_chi2_defl[0]->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), pow(chi2,0.25));

#endif

  if (chi2 > _p0 + _p1 * eta2 + _p2 * eta2 * eta2)
    return 0;

#ifdef DEBUGPAMCUT

  h_trk_chi2_defl[1]->Fill(event->GetTrack(0)->GetTrkTrack()->GetDeflection(), pow(chi2,0.25));

#endif

  return CUTOK;

}
