/*
 * TrkDedxHCut.h
 *
 *  Created on: 26-mar-2009
 *      Author: Nico De Simone, S. Ricciarini
 */

/*! @file TrkDedxHCut.h The TrkDedxHCut class definition file */

#ifndef TRKDEDXHCUT_H_
#define TRKDEDXHCUT_H_

#include "../../PamCutBase/PamCutBase.h"

#include <TH2F.h>

/*! @brief The dE/dX cut to select H and anti-H.
 * This cut discards all the events whose rigidity modulus and dE/dX (both given by TRK) are outside a pre-defined band (by Nico De Simone).
 * Here rigidity is defined as p/Z (GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus: therefore rigidity can be positive or negative.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */
class TrkDedxHCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkDedxHCut(const char *cutName) :
    PamCut(cutName) {

#ifdef DEBUGPAMCUT

    TString hId;
    TString hTitle;

    for (UInt_t j = 0; j < 2; j++) {
      hId.Form("h_trk_he_dedx_vs_rigmod_%i", j);
      hTitle.Form("TRK HE dE/dX vs |rig| (%i)", j);
      h_trk_he_dedx_rigmod[j] = new TH2F(hId.Data(), hTitle.Data(), 50, 0, 20, 50, 0, 10);
    }
    for (UInt_t j = 0; j < 2; j++) {
      hId.Form("h_trk_le_dedx_vs_rigmod_%i", j);
      hTitle.Form("TRK LE dE/dX vs |rig| (%i)", j);
      h_trk_le_dedx_rigmod[j] = new TH2F(hId.Data(), hTitle.Data(), 60, 0, 3, 50, 0, 10);
    }

#endif

  }

  /*! @brief Destructor. */
  ~TrkDedxHCut() {

#ifdef DEBUGPAMCUT

    for (UInt_t j = 0; j < 2; j++) {
      h_trk_he_dedx_rigmod[j]->Write();
      h_trk_le_dedx_rigmod[j]->Write();
    }

#endif

  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the (rigidity modulus , dE/dX) point is inside the pre-defined band.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

#ifdef DEBUGPAMCUT

  TH2F* h_trk_he_dedx_rigmod[2];
  TH2F* h_trk_le_dedx_rigmod[2];

#endif

  // lower cut line
  static const int _nLow = 23;
  static const Double_t _xLow[];
  static const Double_t _yLow[];

  // higher cut line
  static const int _nHigh = 21;
  static const Double_t _xHigh[];
  static const Double_t _yHigh[];

};
#endif
