/*
 * TrkChi2Defl75Cut.h
 *
 *  Created on: 7-apr-2009
 *      Author: Nicola Mori
 */

#ifndef TRKCHI2DEFL75CUT_H_
#define TRKCHI2DEFL75CUT_H_

/*! @file TrkChi2Defl75Cut.h The TrkChi2Defl75Cut class definition file */

#include "../TrkChi2DeflCut.h"

/*! @brief The tracker chi2 vs deflection cut at ~ 75% efficiency.
 *
 * This cut is a specialization of TrkChi2DeflCut, which gives about
 * 75% efficiency.
 */

class TrkChi2Defl75Cut: public TrkChi2DeflCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkChi2Defl75Cut(const char *cutName) :
    TrkChi2DeflCut(cutName, 2.772, 69.08, 51.63) {
  }
  /*! @brief Destructor. */
  ~TrkChi2Defl75Cut() {
  }

};
#endif /* TRKCHI2DEFL75CUT_H_ */
