/*
 * TrkChi2DeflTimeCut.cpp
 *
 *  Created on: 6-oct-2009
 *      Author: S. Ricciarini
 */

#include "TrkChi2DeflTimeCut.h"

double TrkChi2DeflTimeCut::_GetChi2(PamLevel2 *event) {
  return event->GetTrack(0)->GetTrkTrack()->chi2;
}

int TrkChi2DeflTimeCut::Check(PamLevel2 *event) {

  double chi2 = _GetChi2(event);
  if (chi2 < 0.)
    return 0;
  Double_t etaMod = fabs(event->GetTrack(0)->GetTrkTrack()->GetDeflection());

  _time.Set(event->GetOrbitalInfo()->absTime, kFALSE, 0, kFALSE);
  // TTimestamp::GetDate() returns date in format YYYYMMDD so to compare it
  // with 6-digits dates (YYMMDD) we must subtract 20000000

  Int_t iDaySel = (_time.GetDate(kFALSE) - 20000000); // note: GetDate returns an unsigned integer

  bool found = false;
  for (UInt_t i = 0; i < _iDayFirst.size(); i++) {
    if (_iDayFirst[i] <= iDaySel && iDaySel <= _iDayLast[i]) {
      _p0sel = _p0[i];
      _p1sel = _p1[i];
      _p2sel = _p2[i];
      _p3sel = _p3[i];
      //      cout << "FOUND: day " << iDaySel << endl;
      //      cout << _iDayFirst[i] << " " << _iDayLast[i] << endl;
      //      cout << _p0sel << " " << _p1sel << " " << _p2sel << " " << _p3sel << endl;
      found = true;
      break;
    }
  }

  if (!found)
    return 0;

  if (chi2 > _p0sel + _p1sel * pow(etaMod, _p2sel) * (1. + pow(_p3sel * etaMod, 2))) {
    return 0;
  }

  return CUTOK;

}
