/*
 * TrkDeflCut.h
 *
 *  Created on: 14-sep-2010
 *      Author: Nicola Mori
 */

/*! @file TrkDeflCut.h The TrkDeflCut class definition file */

#ifndef TRKDEFLCUT_H_
#define TRKDEFLCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The deflection cut.
 * This cut discards all the events whose deflection is above or below a threshold value.
 * Here deflection is defined as Z/p (1/GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus:
 * therefore deflection can be positive or negative.
 *
 */
class TrkDeflCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param minDeflection The threshold  p/Z (in GV); can be positive or negative.
   * @param discardBelow If true, events below the threshold  will be discarded;
   *                     otherwise, events above the threshold will be discarded.
   */
  TrkDeflCut(const char *cutName, float thrDeflection, bool discardBelow = true ) :
    PamCut(cutName), _thrDeflection(thrDeflection), _discardBelow(discardBelow) {
  }
  /*! @brief Destructor. */
  ~TrkDeflCut() {
  }

  /*! @brief The  check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the deflection is greater (lower) than the threshold and discardBelow is true (false).
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _thrDeflection;
  bool _discardBelow;

};
#endif /* TRKDEFLCUT_H_ */
