/*
 * TrkHitQualCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori
 */

/*! @file TrkHitQualCut.h The TrkHitQualCut class definition file */

#ifndef TRKHITQUALCUT_H_
#define TRKHITQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker hit quality cut.
 *
 * This cut performs a check on the number of hits on X and Y view, on the X lever arm and on the impact angle.
 *
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */

class TrkHitQualCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param xMinHit The minimum number of hits along the track for X view
   * @param yMinHit The minimum number of hits along the track for X view
   * @param xLeverArm The minimum lever arm for X view
   * @param xAngMin The minimum XZ angle (degrees) measured from vertical axis on the first TRK plane (can either positive or negative)
   * @param xAngMax The maximum XZ angle (degrees) measured from vertical axis on the first TRK plane (can either positive or negative)
   */
  TrkHitQualCut(const char *cutName, int xMinHit, int yMinHit, int xLeverArm, Float_t xAngMin=-90., Float_t xAngMax=+90.) :
    PamCut(cutName), _xMinHit(xMinHit), _yMinHit(yMinHit), _xLeverArm(xLeverArm), _xAngMin(xAngMin), _xAngMax(xAngMax) {
  }
  /*! @brief Destructor. */
  ~TrkHitQualCut() {
  }

  /*! @brief The tracker hit quality check.
   *
   * The event is rejected if number of X hits or Y hits or X lever arm is less than the
   * parameter passed to the constructor or if the angle is not inside the specified range.
   *
   * @see TrkHitQualCut
   * @param event The event to analyze.
   * @return #CUTOK if X hits, Y hits and X lever arm are greater or equal than the minimum values and if the XZ angle satisfies the condition xAngMin < angle < xAngMax.
   * @return 0 if at least one of the above conditions is not matched.
   */
  int Check(PamLevel2 *event);

private:

  int _xMinHit, _yMinHit, _xLeverArm;
  Float_t _xAngMin, _xAngMax;

};
#endif /* TRKHITQUALCUT_H_ */
