/*
 * TrkSaturationCut.h
 *
 *  Created on: 31/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TrkSaturationCut.h The TrkSaturationCut class definition file */

#ifndef TRKSATURATIONCUT_H_
#define TRKSATURATIONCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The tracker saturation cut.
 *
 * This cut checks if the clusters on the track are saturated. It can reject events with
 * at least one saturated cluster or events with no saturated cluster, depending on the
 * value of the discardSaturated parameter passed to the constructor.
 */
class TrkSaturationCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param discardSaturated If true, events with at least one saturated cluster along the track are discarded.
   *                         If false, events with no saturated cluster along the track are discarded.
   * */
  TrkSaturationCut(const char *cutName, bool discardSaturated = true) :
    PamCut(cutName), _discardSaturated(discardSaturated) {
  }
  /*! @brief Destructor. */
  ~TrkSaturationCut() {
  }

  /*! @brief The tracker saturation check.
   *
   * This method checks the clusters along the track.
   *
   * @param event The event to analyze.
   * @return #CUTOK if (at least one saturated cluster && discardSaturated = false) || (no saturated cluster && discardSaturated = true).
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  bool _discardSaturated;

};
#endif /* TRKSATURATIONCUT_H_ */
