/*
 * TrkDedxNucleiCut.h
 *
 *  Created on: 8/jul/2010
 *      Author: Nicola Mori
 */

#ifndef TRKDEDXNUCLEICUT_H_
#define TRKDEDXNUCLEICUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The dE/dX cut to select nuclei (Z >= 2)
 * This cut keeps all the events whose energy release in tracker exceeds the lower
 * limit of the He band. This will effectively discard only Z = 1 particles.
 * The selection algorithm is different from that used in #TrkDedxHeCut: here no smart dE/dx computation
 * is performed, ie., there's no exclusion of high release clusters nor separate check on X and Y views.
 * This may result in a little contamination from protons.
 * CUT DEPENDENCIES: TrkPhSinCut for object TrkTrack
 */
class TrkDedxNucleiCut: public PamCut {

public:

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   */
  TrkDedxNucleiCut(const char *cutName) :
    PamCut(cutName) {
  }

  /*! @brief Destructor. */
  ~TrkDedxNucleiCut() {
  }

  /*! @brief The tracker dE/dx vs rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the event lies above the lower limit of the helium band.
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);
};
#endif /* TRKDEDXNUCLEICUT_H_ */
