/*
 * TrkRigCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TrkRigCut.h The TrkRigCut class definition file */

#ifndef TRKRIGCUT_H_
#define TRKRIGCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The rigidity cut.
 * This cut discards all the events whose rigidity is less than the threshold.
 * Here rigidity is defined as p/Z (GV) where Z is the particle charge (WITH SIGN) and p the momentum modulus: therefore rigidity can be positive or negative.
 */
class TrkRigCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param minRigidity The minimum rigidity p/Z (in GV) below which an event
   *        will be discarded. Can be positive or negative.
   */
  TrkRigCut(const char *cutName, float minRigidity) :
    PamCut(cutName), _minRigidity(minRigidity) {
  }
  /*! @brief Destructor. */
  ~TrkRigCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the rigidity is greater than the threshold
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _minRigidity;

};
#endif /* TRKRIGCUT_H_ */
