/*
 * TrkHitQualCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini
 */

/*! @file TrkHitQualCut.cpp The TrkHitQualCut class implementation file */

#include "TrkHitQualCut.h"

int TrkHitQualCut::Check(PamLevel2 *event) {

  TrkTrack *trkTrack = event->GetTrack(0)->GetTrkTrack();

  if (trkTrack->GetNX() < _xMinHit || // minimum number of X planes included in the track
      trkTrack->GetNY() < _yMinHit || // minimum number of Y planes included in the track
      trkTrack->GetLeverArmX() < _xLeverArm || // minimum LA for X view
      trkTrack->axv[0]<_xAngMin || // minimum XZ angle
      trkTrack->axv[0]>_xAngMax) // maximum XZ angle
    return 0;

  return CUTOK;

}
