/*
 * TrkRigCut.h
 *
 *  Created on: 09-apr-2010
 *      Author: S. Ricciarini
 */

/*! @file TrkYSensCut.h The TrkYSensCut class definition file */

#ifndef TRKYSENSCUT_H_
#define TRKYSENSCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The TRK Y sensor cut.
 * This cut selects only events for which the TRK hit sensor id. sensorId.
 */
class TrkYSensCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param sensorId The TRK sensor id. along Y (0-1 for increasing Y)
   */
  TrkYSensCut(const char *cutName, Int_t sensorId) :
    PamCut(cutName), _sensorId(sensorId) {
  }
  /*! @brief Destructor. */
  ~TrkYSensCut() {
  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the rigidity is greater than the threshold
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  Int_t _sensorId;

};
#endif /* TRKYSENSCUT_H_ */
