/*
 * TrkPhSinCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TrkPhSinCut.cpp The TrkPhSinCut class implementation file */

#include "TrkPhSinCut.h"

int TrkPhSinCut::Check(PamLevel2 *event) {

  if (!(event->GetNTracks(trkAlg) == 1))
    return 0; // one track exists (physical or not)

  
  // selection of the physical track (see TrkId below)
  event->SetSortingMethod(_sortingMethod);
  PamTrack *pamTrack = event->GetTrack(0,trkAlg);
//  PamTrack *pamTrack = event->GetTrackOld(0);
//  event->GetTrack(0,trkAlg)->Copy(*pamTrack); //fondamentale per i tagli successivi?!?!

//  return 0;


  ExtTrack* trkTrack = pamTrack->GetExtTrack();
//  TrkTrack* trkTrack = pamTrack->GetTrkTrack();
  if(!trkTrack)return 0;

  // Check if good clusters have meaningful energy releases
  for (unsigned int ip = 0; ip < 6; ip++) {
    if (trkTrack->XGood(ip) == 1 && trkTrack->GetDEDX(ip, 0) <= 0.)
      trkTrack->xgood[ip] = 0; // Set it to bad
    if (trkTrack->YGood(ip) == 1 && trkTrack->GetDEDX(ip, 1) <= 0.)
      trkTrack->ygood[ip] = 0; // Set it to bad
  }

  if (!(trkTrack->nstep < 100 && trkTrack->chi2 > 0.))
    return 0; // check that the track is meaningful

  return CUTOK;

}
