/*
 * TrkCuts.h
 *
 *  Created on: 15-mag-2009
 *      Author: Nicola Mori
 */

/*! @file TrkCuts.h This header contains the inclusion of all Trk cuts. */

#ifndef TRKCUTS_H_
#define TRKCUTS_H_

#include "TrkCalQualCut/TrkCalQualCut.h"                         // Tracker calibration
#include "TrkChi2DeflTimeCut/TrkChi2DeflTimeCut.h"               // Chi2 as a function of deflection with time-dependent calibration
#include "TrkChi2XDeflTimeCut/TrkChi2XDeflTimeCut.h"             // Chi2 for X view as a function of deflection with time-dependent calibration
#include "TrkDedxHCut/TrkDedxHCut.h"                             // Tracker dE/dX for H
#include "TrkDedxHeCut/TrkDedxHeCut.h"                           // Tracker dE/dX for He (empirical function from Elena V.)
#include "TrkDedxNucleiCut/TrkDedxNucleiCut.h"                   // Z >= 2 from tracker dE/dX
#include "TrkDOFCut/TrkDOFCut.h"                                 // Degrees of freedom of the track
#include "TrkGeomCut/TrkGeomCut.h"                               // Fiducial acceptance with tracker's track
#include "TrkHitQualCut/TrkHitQualCut.h"                         // Number of hits and lever arm
#include "TrkIdCut/TrkIdCut.h"                                   // Track identification
#include "TrkIonCut/TrkIonCut.h"                                 // Energy release
#include "TrkMDRCut/TrkMDRCut.h"                                 // MDR
#include "TrkNucleiZCut/TrkNucleiZCut.h"                         // Particle 's charge cut based on TrkNuclei
#include "TrkPhSinCut/TrkPhSinCut.h"                             // Single physical track
#include "TrkRigCut/TrkRigCut.h"                                 // Rigidity minimum or maximum
#include "TrkRigGeoCut/TrkRigGeoCut.h"                           // Rigidity vs. Cutoff
#include "TrkRigMDRCut/TrkRigMDRCut.h"                           // Rigidity vs. MDR
#include "TrkRigRangeCut/TrkRigRangeCut.h"                       // Rigidity range
#include "TrkRunValCut/TrkRunValCut.h"                           // TRK run validation
#include "TrkSaturationCut/TrkSaturationCut.h"                   // TRK cluster saturation
#include "TrkSigmaDeflCut/TrkSigmaDeflCut.h"                     // Sigma-Deflection
#include "TrkYSensCut/TrkYSensCut.h"                             // Sensor selection

#endif /* TRKCUTS_H_ */
