/*
 * TrkSigmaDeflCut.h
 *
 *  Created on: 23-apr-2009
 *      Author: S. Ricciarini
 */

/*! @file TrkSigmaDeflCut.h The TrkSigmaDeflCut class definition file */

#ifndef TRKSIGMADEFLCUT_H_
#define TRKSIGMADEFLCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The cut on TRK sigma_deflection.
 *
 * This cut discards an event if its sigma_deflection (defined as sqrt(coval[4][4]), in GV^-1)
 * multiplied by a constant parameter is not less than the minimum deflection for the bin which
 * contains the event deflection modulus (deflection of the first TRK track).
 *
 */
class TrkSigmaDeflCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param binning A vector containing the histogram binning in rigidity.
   *                Note that it must contain both the upper and lower limits, and
   *                that the elements must be ordered (ie., lowest rigidity value in the first
   *                element and so on).
   */
  TrkSigmaDeflCut(const char *cutName, std::vector<float> binning, float sigmaDeflFactor = 1.) :
    PamCut(cutName), _binning(binning), _sigmaDeflFactor(sigmaDeflFactor) {
  }

  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param rigBinListFileName A text file containing the histogram binning.
   *                Note that it must contain both the upper and lower limits, and
   *                that the elements must be ordered (ie., lowest rigidity value in the first
   *                element and so on).
   */
  TrkSigmaDeflCut(const char *cutName, const char* rigBinListFileName, float deflFactor = 1.);

  /*! @brief Destructor. */
  ~TrkSigmaDeflCut() {
  }

  /*! @brief The sigma_deflection check.
   *
   * The event is discarded if its deflection is less than the lower
   * histogram limit or higher than the upper limit. The event is also discarded if its sigma_deflection is not less than the minimum deflection for the bin which contains the event deflection modulus.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the sigma_deflection condition is satisfied.
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  std::vector<float> _binning;
  float _sigmaDeflFactor;

};

#endif /* TRKSIGMADEFLCUT_H_ */
