/*
 * TofTopS1Cut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori
 */

/*! @file PktQualCut.h The PktQualCut class definition file */

#ifndef TOFTOPS1CUT_H_
#define TOFTOPS1CUT_H_

#include "../../PamCutBase/PamCutBase.h"


/*! @brief The TofTopS1 cut.
 * This cut ensures that no more than 2 PMT's on S1 are hit.
 */

class TofTopS1Cut: public PamCut {

public:
  /*! @brief Constructor.  */
  TofTopS1Cut(const char *cutName): PamCut(cutName){
  }
  /*! @brief Destructor. */
  ~TofTopS1Cut() {
  }

  /*! @brief The TofTopS1 check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if no more than 2 PMTs are hit on each layer of S1
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:

  int _nHitPmtPl[2]; // Number of hit PMT on each layer of S1

};

#endif /* TOFTOPS1CUT_H_ */
