/*
 * TofQualCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofQualCut.cpp The TofQualCut class implementation file */

#include "TofQualCut.h"

int TofQualCut::Check(PamLevel2 *event) {

  // Array initialization
  for (int ipair = 0; ipair < 3; ipair++) {
    _nHitPadPair[ipair] = 0;
  }

  // Compute the number of hit paddles on each pair of layers
  for (int il = 0; il < 6; il++) {
    int ipair=il/2; // division between integers
    _nHitPadPair[ipair]+=event->GetToFLevel2()->GetNHitPaddles(il);
  }

  // CUT
  for (int ipair = 0; ipair < 3; ipair++) {
    if (!(_nHitPadPair[ipair] >= 1))
      return 0;
  }

  return CUTOK;
}
