/*
 * TofQualCut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TofQualCut.h The TofQualCut class definition file */

#ifndef TOFQUALCUT_H_
#define TOFQUALCUT_H_

#include "../../PamCutBase/PamCutBase.h"


/*! @brief The TofQual cut.
 * This cut ensures that for each TOF plane (each pair of layers) at least one paddle is hit (according to standard TOF definition: both TDC's are hit and both hits are 'good')
 */

class TofQualCut: public PamCut {

public:
  /*! @brief Constructor.  */
  TofQualCut(const char *cutName): PamCut(cutName){
  }
  /*! @brief Destructor. */
  ~TofQualCut() {
  }

  /*! @brief The TofQual check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if for each pair of layers at least one paddle is hit
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:

  int _nHitPadPair[3]; // Number of hit paddles on each pair of layers

};

#endif /* TOFQUALCUT_H_ */
