/*
 * TofPatternCut.cpp
 *
 *  Created on: 12-mar-2009
 *      Author: Elena Vannuccini
 */

/*! @file TofPatternCut.cpp The ToFPatternCut class implementation file */

#include "TofPatternCut.h"

int TofPatternCut::Check(PamLevel2 *event) {

  if (!event)
    return (0);
  //
  ToFLevel2 *tofl2 = event->GetToFLevel2();
  if (!tofl2)
    return (0);
  ToFTrkVar *tof = 0;
  if (!_standalone && _notrk >= 0 && _notrk < event->GetTrkLevel2()->GetNTracks())
    tof = event->GetTrack(_notrk)->GetToFTrack();
  if (_standalone)
    tof = event->GetToFStoredTrack(-1);
  if (!tof)
    return (0);

#ifdef DEBUGPAMCUT
    cout << ">>> TofPatternCut CHECK <<<" << endl;
#endif

  bool TOF__OK = false;

#ifdef DEBUGPAMCUT
    cout << "Check topology:" << endl;
    for (int ip = 0; ip < 6; ip++)
      cout << "plane " << ip << " n.hit paddles " << tofl2->GetNHitPaddles(ip) << endl;
    for (int ip = 0; ip < 6; ip++)
      cout << "plane " << ip << " n.hit PMTs outside track " << GetNHitPMTsOutsideTrack(event, ip) << endl;
#endif

  // -----------------------------------------
  // at least one hit paddle on both S1 and S2
  // -----------------------------------------
  if (
  //-----------------------------------
  // not more than 1 paddle per layer
  //-----------------------------------
  tofl2 && tofl2->GetNHitPaddles(0) <= 1 && //S11
      tofl2->GetNHitPaddles(1) <= 1 && //S12
      tofl2->GetNHitPaddles(2) <= 1 && //S21
      tofl2->GetNHitPaddles(3) <= 1 && //S22
      //	tofl2->GetNHitPaddles(4) <= 1 && //S31
      //	tofl2->GetNHitPaddles(5) <= 1 && //S32
      //-----------------------------------
      // at least 1 paddle per plane
      //-----------------------------------
      (tofl2->GetNHitPaddles(0) == 1 || tofl2->GetNHitPaddles(1) == 1) && //S1
      (tofl2->GetNHitPaddles(2) == 1 || tofl2->GetNHitPaddles(3) == 1) && //S2
      //	(tofl2->GetNHitPaddles(4)==1 || tofl2->GetNHitPaddles(5)==1) && //S3
      //-----------------------------------
      // n.hit pmts outside track
      //-----------------------------------
      //  	GetHitPMTsOutsideTrack(event,0)<2 && //S11	 //troppo (puo` succedere )
      //  	GetHitPMTsOutsideTrack(event,1)<2 && //S12
      //  	GetHitPMTsOutsideTrack(event,2)<2 && //S21
      //  	GetHitPMTsOutsideTrack(event,3)<2 && //S22
      GetNHitPMTsOutsideTrack(event, 0) < 3 && //S11
      GetNHitPMTsOutsideTrack(event, 1) < 3 && //S12
      // 	GetHitPMTsOutsideTrack(event,2)<3 && //S21
      // 	GetHitPMTsOutsideTrack(event,3)<3 && //S22
      true)
    TOF__OK = true;

  if (!TOF__OK) {
#ifdef DEBUGPAMCUT
      cout << "(((DISCARDED)))" << endl;
#endif
    return (0);
  };

#ifdef DEBUGPAMCUT
    cout << "--> OK" << endl;
    cout << "Check track concistency:" << endl;
#endif

  // -----------------------------------------------
  // the hit paddles MUST be associated to the track
  // (in collaborazione con wolfgang)
  // -----------------------------------------------
  //
  //  first build the map of hit PMTs along the track
  //  and discard the event if there is an hit paddle,
  //  but it is not the one associated to the track
  //

  int hitplane[] = { 0, 0, 0, 0, 0, 0 };
  int hitpaddle[] = { -1, -1, -1, -1, -1, -1 };
  for (Int_t ip = 0; ip < tof->npmttdc; ip++) {//loop over tdc hits associated to the track
    Int_t iplane = -1;
    Int_t ipaddle = -1;
    Int_t ipmt = -1;
    Int_t id = tof->pmttdc[ip];//pmt id
    tofl2->GetPMTName(id, iplane, ipaddle, ipmt);
    if (tof->tdcflag[ip] == 0) {
      hitplane[iplane] = 1; //there is a true tdc signal associated to the track
#ifdef DEBUGPAMCUT
      if (hitpaddle[iplane] >= 0 && hitpaddle[iplane] != ipaddle)
        cout << "ORRORE!!!!" << endl;
#endif
      hitpaddle[iplane] = ipaddle;//store the id of the paddle associated to the track
      //
      //
      //
      if (tofl2->GetNHitPaddles(iplane) > 0 && //if there is a hit paddle in this plane...
          !tofl2->HitPaddle(iplane, hitpaddle[iplane]) && //... and the paddle associated to the track is not hit
          true) {
#ifdef DEBUGPAMCUT
          cout << "hit plane " << iplane << " -- track PMT " << hitpaddle[iplane] << " is not hit " << endl;
          cout << "(((DISCARDED)))" << endl;
#endif
        return (0);//discard the event
      }
    }
  };
  //
  // hence check the planes with no PMTs associated to the track:
  // the event is discarded if there is a hit paddle
  //
  for (int iplane = 0; iplane < 4; iplane++) {//loop over S11/S12/S21/S22
    if (hitplane[iplane] == 0 && //if there are no PMTs associated to the track...
        tofl2->GetNHitPaddles(iplane) > 0 && //...and the plane has hit paddles
        true) {
#ifdef DEBUGPAMCUT
        cout << "hit plane " << iplane << " has no PMTs associated to the track " << endl;
        cout << "(((DISCARDED)))" << endl;
#endif
      return (0);//discard the event
    }
  }

  //
  // forse non c'e` bisogno di tutto cio`?
  //
  //     for(int iplane=0; iplane<4; iplane++){//loop over S11/S12/S21/S22
  // 	//retrieve the id of the paddle traversed by the track
  // 	// (...there is some tolerance...)
  // 	int ipaddle = tofl2->GetPaddleIdOfTrack(tof->xtr_tof[iplane],tof->ytr_tof[iplane],iplane);
  // 	//check if the traversed paddle is hit
  // 	bool OK = true;
  // 	if(
  // 	    tofl2->GetNHitPaddles(iplane)>0 &&//if there is a hit paddle in this plane...
  // 	    !tofl2->HitPaddle(iplane,ipaddle) && //...and the paddle traversed by the track is not hit
  // 	    true)OK = false;//..discard the event
  // 	/// hence try to recover some events...
  // 	if(
  // 	    tofl2->GetNHitPaddles(iplane)>0 &&//if there is a hit paddle...
  // 	    ipaddle==-1 &&//...and the track does not traverse any paddle...
  // 	    tofl2->HitPaddle(iplane,hitpaddle[iplane]) &&//... BUT there are tdc signals belonging to a hit paddle
  // 	    true)OK=true;//recover

  // 	if(!OK)return (0);

  //     }

  //    if( !TOF__OK )return (0);

#ifdef DEBUGPAMCUT
    cout << "--> OK" << endl;
#endif

  return CUTOK; //good pattern

}
//===========================================================
//
//
//
//
//
//===========================================================
int TofPatternCut::GetNHitPMTsOutsideTrack(PamLevel2 *event, int plane) {

  if (!event)
    return (0);
  //
  ToFLevel2 *tofl2 = event->GetToFLevel2();
  if (!tofl2)
    return (0);
  ToFTrkVar *tof = 0;
  if (!_standalone && _notrk >= 0 && _notrk < event->GetTrkLevel2()->GetNTracks())
    tof = event->GetTrack(_notrk)->GetToFTrack();
  if (_standalone)
    tof = event->GetToFStoredTrack(-1);
  if (!tof)
    return (0);

  int nn = 0;
  //    cout << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%"<<endl;
  for (int ip = 0; ip < tofl2->npmt(); ip++) { //loop over ALL PMTs
    Int_t iplane = -1;
    Int_t ipaddle = -1;
    Int_t ipmt = -1;
    Int_t id = tofl2->GetToFPMT(ip)->pmt_id; //PMT id
    tofl2->GetPMTName(id, iplane, ipaddle, ipmt);

    if (iplane != plane)
      continue;
    //	cout << endl<<plane << " -- "<<id;
    float tdc = tofl2->GetToFPMT(ip)->tdc;
    if (tdc >= 4095.)
      continue;///to avoid adc pile-up
    // spiegazione:
    // quando c'e` adc pile-up, succede che un pmt abbia un segnale adc (adc<4095) ma NON tdc (tdc==4095),
    // che e` il contrario di quanto avviene di solito. quindi, se nel livello 2 c'e` un pmt colpito
    // e questo ha tdc==4095, implica che c'e` solo il segnale adc e che probabilmente non e` un vero segnale,
    // ma e` il pile-up dell'evento precedente

    // loop over TDC hits along the track
    int iht = -1;
    for (iht = 0; iht < tof->npmttdc; iht++)
      if (id == tof->pmttdc[iht])
        break; //match
    if (iht >= 0 && iht < tof->npmttdc)
      continue;
    // loop over ADC hits along the track (credo sia inutile...)
    //	int iha = -1;
    //   	for(iha=0; iha<tof->npmtadc; iha++)if(id==tof->pmtadc[iha])break; //match
    //   	if( iha>=0 && iha <tof->npmtadc )continue;
    // get here if outside track
    nn++;

    //	cout << " OUTSIDE ";
  }
  return nn;

}

