/*
 * TofDedxS1Cut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 */

/*! @file TofDedxS1Cut.h The TofDedxS1Cut class definition file */

#ifndef TOFDEDXS1CUT_H_
#define TOFDEDXS1CUT_H_

#include "../../PamCutBase/PamCutBase.h"


/*! @brief The TofQual cut.
 * This cut is done for each S1 layer: if there is one and only one hit paddle for the layer, then the dE/dX of the paddle (referred to a specified track) must be less than a fixed threshold. NOTE: 'hit paddle' means that both TDC signals are present AND they are both 'good' (according to TOF definition of 'good' TDC signal)
 *
 */

class TofDedxS1Cut: public PamCut {

public:
  /*! @brief Constructor.
  *
  * The parameters are: maximum dE/dX for S1 layers and the TOF-index for the track which is necessary to input to derive the dE/dX for S1 layers.
  *
  * @param cutName The cut's name.
  * @param maxDedxS1 The maximum dE/dX for each S1 layer, for which the event is accepted
  * @param trackTof Pointer to the TOF-index indicating the track to be used when evaluating the dE/dX for S1 layers (default value for TOF_index is 0, corresponding to the TOF stand-alone track [no TRK information to build the TOF stand-alone track]). The pointer to the TOF_index for TRK-track as given by TrkPhSinCut can be used.
  *
  */
  TofDedxS1Cut(const char *cutName, float maxDedxS1, int *trackTof=NULL):
    PamCut(cutName), _maxDedxS1(maxDedxS1), _trackTof(trackTof) {
  }
  /*! @brief Destructor. */
  ~TofDedxS1Cut() {
  }

  /*! @brief The TofDedxS1 check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if for each layer of S1 with one and only one hit paddle, the paddle dE/dX is less than a fixed threshold
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:

  float _maxDedxS1;
  int *_trackTof;
  int _nHitPadPair[3]; // Number of hit paddles on each pair of layers

};

#endif /* TOFDEDXS1CUT_H_ */
