/*
 * TofDedxS1Cut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofDedxS1Cut.cpp The TofDedxS1Cut class implementation file */

#include "TofDedxS1Cut.h"

int TofDedxS1Cut::Check(PamLevel2 *event) {

  int iTrackTof=0; // index initialized to 0 (TOF stand-alone track)
  if (! (_trackTof==0) ) {
    iTrackTof=*_trackTof;
  }

  // for each layer of S1: check that there is one and only one hit paddle and identify it; if this condition is satisfied, do the check on DeDx for the paddle (otherwise no check is done)

  for (int ipl=0; ipl<2; ipl++) {
  
    int nhitpad = 0; // number of hit paddles
    int ihitpad = 100; // identifier of hit paddle; maximum valid value is 24 (taking into account each possible TOF layer)
    float dedxpad;

    for (int ipad=0; ipad<TOFNPADLAYER[ipl]; ipad++) {
      if (event->GetToFLevel2()->HitPaddle(ipl,ipad)) { // HitPaddle is true if and only if there are both TDC signal for that pad AND they are both 'good'
	ihitpad=event->GetToFLevel2()->GetPaddleid(ipl,ipad);
	nhitpad++;
      }
    }

    if (nhitpad == 1) { // there is one and only one hit pad in the layer
      int satwarnpad;
      event->GetToFLevel2()->GetdEdxPaddle(iTrackTof,ihitpad,100,dedxpad,satwarnpad);
      // NOTE: if dedxpad=0 then there is no dE/dL signal (i.e. no ADC signals to evaluate dE/dL): this means that ADC signals are under threshold and therefore event is good
      if ( ! (dedxpad < _maxDedxS1) ) {
//        cout << "return on check " << ipl << " hitpad " << ihitpad << " track id " << *_trackTof << " dedxpad " << dedxpad << endl;
        return ipl;
      }
    }
          
  }

  return CUTOK;
  
}
