/*
 * TofDedxS1Cut.h
 *
 *  Created on: 13-mar-2009
 *      Author: Nicola Mori, S. Ricciarini
 *  Reworked on: 21-jul-2011
 *      Author: Nicola Mori, Valeria Di Felice
 */

/*! @file TofDedxS1Cut.h The TofDedxS1Cut class definition file */

#ifndef TOFDEDXS1CUT_H_
#define TOFDEDXS1CUT_H_

#include "../../PamCutBase/PamCutBase.h"


/*! @brief A cut on energy release on S1.
 *
 * This cut discards events whose mean dE/dx on S11+S12 is greater than a specified functional form.
 * Currently, this functional form is:
 *
 *    <dE/dx> < (3.102 - 2.6*TMath::Log(R))*(R<1.05) + 3.*(R=1.05)
 *
 * Since this cut uses the rigidity, it is necessary to enforce the existence of a physical track
 * using #TrkPhsinCut before using this cut.
 */

class TofDedxS1Cut: public PamCut {

public:
  /*! @brief Constructor.
  *
  * @param cutName The cut's name.
  *
  */
  TofDedxS1Cut(const char *cutName):
    PamCut(cutName){
  }
  /*! @brief Destructor. */
  ~TofDedxS1Cut() {
  }

  /*! @brief The TofDedxS1 check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if <dE/dx> is lesser that the threshold function.
   * @return 0 otherwise
   */
  int Check(PamLevel2 *event);

private:

};

#endif /* TOFDEDXS1CUT_H_ */
