/*
 * TofDedxHeCut.h
 *
 *  Created on: 03/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TofDedxHeCut.h  The TofDedxHeCut.h class definition file. */

#ifndef TOFDEDXHECUT_H_
#define TOFDEDXHECUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief Cutting a band dE/dx vs. Beta for Helium.
 * This cut discards events where TOF dE/dx vs. Beta are outside the helium "corridor". This corridor is currently
 * defined by:
 *
 * dE/dx > 1 / (p[0] * pow(beta, p[4]) + p[1]) + p[2] + p[3]*beta
 * dE/dx < 1 / (p[5] * pow((*beta), p[9]) + p[6]) + p[7] + p[8]*(*beta);
 *
 * where p[i] are calibration parameters. Currently, they are available for each single layer; the beta used is the beta[12] corresponding
 * to the TOF standalone track or to the TRK physical track, depending on the value of the standAlone parameter of the constructor. The
 * cut parameters have been obtained using the standalone beta, but they have proven to be good also for beta from tracker, so a single
 * set of parameter will be used for both cases.
 * If the required combination of planes has no available calibration, the one for S21 will be used (but it probably won't work well...).
 * In particular, there's no currently available calibration for combinations of layers.
 */
class TofDedxHeCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param layer The layer to use. Select it using values like #S11 (for single layers) or S11+S12 (for the mean of many layers).
   * @param standAlone If true, the cut will use the standalone measure of beta; otherwise it will use the
   *                   physical track.
   */
  TofDedxHeCut(const char *cutName, unsigned int layer, bool standAlone = true);
  /*! @brief Destructor. */
  ~TofDedxHeCut() {

  }

  /*! @brief The dE/dx vs. beta helium check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if event is inside helium "corridor".
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  unsigned int _layer;
  bool _standAlone;
  const float *_p;
  // Single layers standalone
  static const float _S11_SA_params[10], _S12_SA_params[10], _S21_SA_params[10], _S22_SA_params[10], _S31_SA_params[10],
      _S32_SA_params[10];
};

#endif /* TOFDEDXHECUT_H_ */
