/*
 * TofBetaRigCut.h
 *
 *  Created on: 22-apr-2009
 *      Author: S. Ricciarini
 */

/*! @file TofBetaRigHCut.h The TofBetaRigHCut class definition file */

#ifndef TOFBETARIGHCUT_H_
#define TOFBETARIGHCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The match between TOF beta modulus and TRK beta modulus for H (p or d).
 * This cut discards all the events for which the absolute RELATIVE difference between TRK beta modulus (calculated from rigidity of TRK track, mass M=1 OR 2 and charge Z=1) and TOF beta modulus is greater than the threshold.
 * Rigidity is defined as p/Z (GV) where Z is the particle charge and p the momentum modulus.
 */
class TofBetaRigHCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param threshold The rigidity-difference threshold (in GV)
   */
  TofBetaRigHCut(const char *cutName, float threshold) :
    PamCut(cutName), _threshold(threshold) {

  }
  /*! @brief Destructor. */
  ~TofBetaRigHCut() {

  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the beta difference is less than the threshold
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

  float _threshold;

};
#endif /* TOFBETARIGHCUT_H_ */
