/*
 * TofBetaCut.cpp
 *
 *  Created on: 13-mar-2009
 *      Author: Sergio Ricciarini, Nicola Mori
 */

/*! @file TofBetaCut.cpp The TofBetaCut class implementation file */

#include "TofBetaCut.h"

int TofBetaCut::Check(PamLevel2 *event) {

  int iTrackTof=0; // index initialized to 0 (TOF stand-alone track)
  if (! (_trackTof==0) ) {
    iTrackTof=*_trackTof;
  }

  beta = event->GetToFLevel2()->CalcBeta(iTrackTof,_resMax,_qualCut,_chi2Cut);

  if( ! (beta < 100.) ) // NOTE: beta=100 means beta calculation was not successful
    return 0;

  return CUTOK;
  
}
