/*
 * TofPatternCut.h
 *
 *  Created on: 10-mar-2009
 *      Author: Elena Vannuccini
 */

/*! @file TofPatternCut.h The ToFPatternCut class definition file */

#ifndef TOFPATTERNCUT_H_
#define TOFPATTERNCUT_H_

#include "../../PamCutBase/PamCutBase.h"

/*! @brief The Tof-pattern cut.
 *
 * Requirements:
 * - not more than 1 hit paddle on S11 S12 S21 S22;
 * - at least 1 hit paddle on S1 and S2;
 * - not more than 3 hit PMTs (only TDC hits with tdc<4095) outside track;
 *   on S11 and S12;
 * - if there is a hit paddle, the PMTs (TDC hits) must be associated to the track;
 * - if no PMTs (TDC hits) are associated to the track, there must be no hit paddles.
 */
class TofPatternCut: public PamCut {

public:
  /*! @brief Constructor. */
  TofPatternCut(const char *cutName) :
    PamCut(cutName), _standalone(false), _notrk(0) {
  }
  /*! @brief Destructor. */
  ~TofPatternCut() {
  }

  /*! @brief The ToF-pattern check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the event pattern matches the required characteristics.
   */
  int Check(PamLevel2 *event);

  /*! @brief Counts the number of hit PMTs (with tdc signal) outside track
   *
   * @param event The event to analyze.
   * @param plane Plane number (0-5 = S11-S32).
   */
  int GetNHitPMTsOutsideTrack(PamLevel2 *event, int plane);

  /*! @brief Set standalone ToF track. */
  inline void SetStandalone(int yes) {
    if (yes)
      _standalone = true;
    else
      _standalone = false;
  }

  /*! @brief Set (physical) track number (0,1,...). Default is 0 (the first).   */
  inline void SetTrackNumber(int n) {
    _notrk = n;
  }


private:

  bool _standalone;
  int _notrk;

};
#endif /* TOFPATTERNCUT_H_ */
