/*
 * TofDedxHeCut.cpp
 *
 *  Created on: 03/ago/2009
 *      Author: Nicola Mori
 */

/*! @file TofDedxHeCut.cpp The TofDedxHeCut class implementation file. */

#include "TofDedxHeCut.h"

const float TofDedxHeCut::_S11_SA_params[] = { 0.27, 0.045, -4.9, 4.7, 2.6, 0.38, 0.045, 1.7, 2., 2.5 };
const float TofDedxHeCut::_S12_SA_params[] = { 0.27, 0.043, -4.9, 4.7, 2.6, 0.38, 0.042, 1.7, 2., 2.5 };
const float TofDedxHeCut::_S21_SA_params[] = { 0.29, 0.037, -4.52, 4.4, 2.4, 0.28, 0.031, 1., 2.2, 2. };
const float TofDedxHeCut::_S22_SA_params[] = { 0.31, 0.033, -4.52, 4.4, 2.4, 0.29, 0.02, 1., 2.4, 1.9 };
const float TofDedxHeCut::_S31_SA_params[] = { 0.44, 0.029, -2.4, 3.2, 2.5, 0.56, 0.008, 3.2, 1.2, 2.3 };
const float TofDedxHeCut::_S32_SA_params[] = { 0.48, 0.024, -2.4, 3.4, 2.5, 0.64, -0.0071, 3.2, 1.3, 2.3 };

TofDedxHeCut::TofDedxHeCut(const char *cutName, unsigned int layer, bool standAlone) :
    PamCut(cutName), _layer(layer), _standAlone(standAlone), _p(NULL) {

  switch (_layer) {
  case S11:
    _p = _S11_SA_params;
    break;
  case S12:
    _p = _S12_SA_params;
    break;
  case S21:
    _p = _S21_SA_params;
    break;
  case S22:
    _p = _S22_SA_params;
    break;
  case S31:
    _p = _S31_SA_params;
    break;
  case S32:
    _p = _S32_SA_params;
    break;
  default:
    _p = _S21_SA_params;
  }

}

int TofDedxHeCut::Check(PamLevel2 *event) {

  static int trkSeqNo;
  static int idx;
  if (_standAlone)
    trkSeqNo = -1;
  else
    trkSeqNo = event->GetTrack(0)->GetTrkTrack()->GetSeqNo();

  for (int i = 0; i < event->GetToFLevel2()->ntrk(); i++) {
    if (event->GetToFLevel2()->GetToFTrkVar(i)->trkseqno == trkSeqNo)
      idx = i;
  }

  float beta = event->GetToFLevel2()->GetToFTrkVar(idx)->beta[12];

  static unsigned int auxLayer;
  static float dEdx;
  static unsigned int currLayer;
  static unsigned int nLayers;

  auxLayer = _layer;
  dEdx = 0;
  currLayer = 0;
  nLayers = 0;
  while (auxLayer > 0) {
    if ((auxLayer & 0x1) == 1) {
      //cout << auxLayer << "  " << currLayer << endl;
      dEdx += event->GetToFLevel2()->GetdEdx(idx, currLayer, 100);
      nLayers++;
    }
    currLayer++;
    auxLayer >>= 1;
  }

  dEdx /= nLayers;

  if (dEdx < 1. / (_p[0] * pow(beta, _p[4]) + _p[1]) + _p[2] + _p[3] * beta)
    return 0;

  if (dEdx > 1. / (_p[5] * pow(beta, _p[9]) + _p[6]) + _p[7] + _p[8] * beta)
    return 0;

  return CUTOK;
}
