/*
 * TofBetaRigCut.h
 *
 *  Created on: 22-apr-2009
 *      Author: S. Ricciarini
 */

/*! @file TofBetaRigCut.h The TofBetaRigCut class definition file */

#ifndef TOFBETARIGCUT_H_
#define TOFBETARIGCUT_H_

#include "../../PamCutBase/PamCutBase.h"

#include <TH2F.h>

/*! @brief The match between TOF beta modulus and TRK beta modulus.
 * This cut discards all the events for which the absolute RELATIVE difference between TRK beta modulus (calculated from rigidity of TRK track, mass M and charge Z) and TOF beta modulus is greater than the threshold.
 * Rigidity is defined as p/Z (GV) where Z is the particle charge and p the momentum modulus.
 * CUT DEPENDENCIES: TrkPhysSin for object trkTrack
 */
class TofBetaRigCut: public PamCut {

public:
  /*! @brief Constructor.
   *
   * @param cutName The cut's name.
   * @param charge The particle charge (in units of proton charge: e.g. Z=1)
   * @param mass The particle mass (in GeV; e.g. m=0.93827203 GeV)
   * @param threshold The rigidity-difference threshold (in GV)
   */
  TofBetaRigCut(const char *cutName, float threshold, int charge=1, float mass=0.93827203) :
    PamCut(cutName), _threshold(threshold), _charge(charge), _mass(mass) {

#ifdef DEBUGPAMCUT

    TString hId;
    TString hTitle;

    for (UInt_t j = 0; j < 2; j++) {
      hId.Form("h_trk_vs_tof_betamod_%i", j);
      hTitle.Form("TRK |beta| vs TOF |beta| (%i)", j);
      h_trk_vs_tof_betamod[j] = new TH2F(hId.Data(), hTitle.Data(), 50, 0, 1, 50, 0, 1);
    }

#endif

  }
  /*! @brief Destructor. */
  ~TofBetaRigCut() {

#ifdef DEBUGPAMCUT

    for (UInt_t j = 0; j < 2; j++) {
      h_trk_vs_tof_betamod[j]->Write();
    }

#endif

  }

  /*! @brief The rigidity check.
   *
   * @param event The event to analyze.
   * @return #CUTOK if the beta difference is less than the threshold
   * @return 0 otherwise.
   */
  int Check(PamLevel2 *event);

private:

#ifdef DEBUGPAMCUT

  TH2F* h_trk_vs_tof_betamod[2];

#endif

  float _threshold;
  int _charge;
  float _mass;

};
#endif /* TOFBETARIGCUT_H_ */
